def openNewRequestForm
  @common.selectAddAppointmentButton("VA")
  @common.waitWhileSpinnerPresent

  @new_request.back_btn_element.when_visible(TIME_OUT_LIMIT)
  expect(@new_request.has_expected_title?).to eq(true)
  Watir::Wait.until {@new_request.primary_header == "New Appointment/Request"}
end


def addRequest(schedulingMethod, typeOfCare, facilityId, typeOfVisit, purposeOfVisit, otherPurposeOfVisit, desiredDateTime1, desiredDateTime2, desiredDateTime3, phoneNum, verifyPhoneNum, bestTimesForVAtoCall, vaToCallYou, message, sendMeEmail, email  )

  @common.selectAddAppointmentButton("VA")
  @common.waitWhileSpinnerPresent
  @new_request.back_btn_element.when_visible(TIME_OUT_LIMIT)
  @new_request.selectTypeOfCare(typeOfCare)
  @new_request.selectState("523")
  @new_request.location_instruction_element.wait_until_present(TIME_OUT_LIMIT)
  if (@new_request.location_instruction_element.text.include?("One location supports scheduling"))
    @new_request.step_3_scheduling_method_element.wait_until_present(TIME_OUT_LIMIT)
    @new_request.select_scheduling_method_radio(schedulingMethod)
    @common.waitWhileSpinnerPresent
  else
    @new_request.selectLocation(facilityId)
    @new_request.step_3_scheduling_method_element.wait_until_present(TIME_OUT_LIMIT)
    @new_request.select_scheduling_method_radio(schedulingMethod)
    @common.waitWhileSpinnerPresent
  end

  @new_request.request_details_legend_element.when_visible(TIME_OUT_LIMIT)

  expect(@new_request.request_details_legend).to eq("Request Details")


  @new_request.purpose_of_visit = purposeOfVisit
  @new_request.purpose_of_visit_element.fire_event('onblur')

  if purposeOfVisit == "Other" then
    @new_request.other_purpose_text = otherPurposeOfVisit
    @new_request.other_purpose_text_element.fire_event('onblur')
  end

  @new_request.select_type_of_visit_radio(typeOfVisit)

  @new_request.option_date1 = desiredDateTime1[0]

  @new_request.select_am_pm1(desiredDateTime1[1])

  @new_request.option_date2 = desiredDateTime2[0]
  @new_request.select_am_pm2(desiredDateTime2[1])

  @new_request.option_date3 = desiredDateTime3[0]
  @new_request.select_am_pm3(desiredDateTime3[1])

  @new_request.phoneNumber = phoneNum
  @new_request.phoneNumber_element.fire_event('onblur')
  @new_request.verifyPhoneNumber = verifyPhoneNum
  @new_request.verifyPhoneNumber_element.fire_event('onblur')

  if bestTimesForVAtoCall[0] == true then
    @new_request.check_bestTimeToCall_morning
  end

  if bestTimesForVAtoCall[1] == true then
    @new_request.check_bestTimeToCall_afternoon
  end

  if bestTimesForVAtoCall[2] == true then
    @new_request.check_bestTimeToCall_evening
  end


  if vaToCallYou == true then
    @new_request.requestedPhoneCall_yes_element.click
  else
    @new_request.requestedPhoneCall_no_element.click
  end

  @new_request.new_message = message

  if sendMeEmail == true then
    @new_request.select_emailPref("true")
    @new_request.email = email
    @new_request.email_element.fire_event('onblur')

  else
    @new_request.select_emailPref("false")
  end

  #@new_request.submit_element.when_present(TIME_OUT_LIMIT)

  #@new_request.submit
  @new_request.clickSubmitRequest
  @common.waitWhileSpinnerPresent()

  @detail.status_element.when_present(TIME_OUT_LIMIT)
  expect(@detail.has_expected_title?).to eq(true)

end


def verifyTableList(facilityName, lastUpdatedDate, typeOfCare)
  @common.waitWhileSpinnerPresent
  expect(@detail.back_btn_element.exists?).to eq(true)
  @detail.back_btn

  @common.waitWhileSpinnerPresent
  waitTillRequestsDisplay

  #Column 1 Label: Last Updated
  expect(@landing_appointments.getNthRequestTableHeader(1)).to eq("Last Updated")
  expect(@landing_appointments.getRequestTextForRowCol(1,1)).to eq(lastUpdatedDate)

  #Column Label: Status
  expect(@landing_appointments.getNthRequestTableHeader(2)).to eq("Status")
  expect(@landing_appointments.getRequestTextForRowCol(1,2)).to eq("Submitted")

  #Column Label: Facility/Clinic;
  expect(@landing_appointments.getNthRequestTableHeader(3)).to eq("Location")
  expect(@landing_appointments.getNthRequestTableHeader(4)).to eq("Type of Care")
  expect(@landing_appointments.getRequestTextForRowCol(1,3)).to eq(facilityName)
  expect(@landing_appointments.getRequestTextForRowCol(1,4)).to eq(typeOfCare)
end

def  verifyRequestDetails(expected_details, expected_communicating_with_clerk, facilityName)
  @common.waitWhileSpinnerPresent
  @detail.status_element.when_present(TIME_OUT_LIMIT)
  expect(@detail.has_expected_title?).to eq(true)

  expect(@detail.status_element.text).to eq("Status: Submitted")
  expect(@detail.provide_feedback_link_element.text).to eq("Provide feedback on this submission.")
  expect(@detail.status_last_updated_element.text).to include("Updated: " +  @today)
  expect(@detail.status_desc_element.text).to eq("View status updates for this request under the \"Requests\" section of the Appointments and Requests page. Once scheduled, the resulting appointment will be displayed under the “Appointments” section of the same page.")

  actual_text = @detail.request_details_group_element.text.split("\n")
  expected_details.each_with_index do | expectedScreenRow, i |
    if (expectedScreenRow.include?("Submitted:"))
      expect(actual_text[i]).to include("Submitted: " + @today)
      expect(actual_text[i]).to include("Location: " + facilityName)
    else
      expect(actual_text[i]).to eq(expectedScreenRow)
    end
  end

  actual_text = @detail.communicate_with_clerk_group_element.text.split("\n")

  expected_communicating_with_clerk.each_with_index do | expectedScreenRow, i |
    expect(actual_text[i]).to eq(expectedScreenRow)

  end


end

def waitTillRequestsDisplay
  @common.waitWhileSpinnerPresent
  @landing_appointments.primary_header_element.when_present(TIME_OUT_LIMIT)
  expect(@landing_appointments.appointment_header).to eq("Appointments")

  Watir::Wait.until { @landing_appointments.request_table_list_elements.length > 0 }

end

def cancelRequest
  #@detail.cancel_btn_element.click
  #workaround : sometimes @driver does not click element
  button_element = @driver.button(:id => 'cancel-request-btn')
  execute_script("$(arguments[0]).click();",button_element)
  @modal.modalTitle_element.when_present(TIME_OUT_LIMIT)
  expect(@modal.modalTitle).to eq('Confirmation')
  #@modal.buttons_elements[0].click
  button_element = @driver.button(:css => ' .popup-footer-buttons button:nth-child(1)')
  execute_script("$(arguments[0]).click();",button_element)
  @common.waitWhileSpinnerPresent
  @detail.status_element.when_visible
  Watir::Wait.until { @detail.status_element.text == "Status: Cancelled" }
  expect(@detail.status_element.text).to eq("Status: Cancelled")
end


def selectAddAppointmentButton
  @landing_appointments.primary_header_element.when_present(TIME_OUT_LIMIT)
  # Watir::Wait.until {@landing_appointments.request_header == "Requests"}
  # expect(@landing_appointments.request_header).to eq("Requests")
  @common.waitWhileSpinnerPresent

  Watir::Wait.until { @landing_appointments.add_top_btn_element.present? }
  @landing_appointments.add_top_btn_element.when_present(TIME_OUT_LIMIT)
  @landing_appointments.add_top_btn_element.click
  @common.waitWhileSpinnerPresent()
  @new_request.back_btn_element.when_visible(TIME_OUT_LIMIT)
  expect(@new_request.has_expected_title?).to eq(true)
end


def goBack
  button_element = @driver.button(:id => 'back-btn')
  @driver.execute_script("$(arguments[0]).click();",button_element)
  expect(@modal.modalTitle).to eq("Confirmation")
  expect(@modal.buttons_elements[0].text).to eq("Continue")
  @modal.buttons_elements[0].click
  expect(@landing_appointments.primary_header).to eq("Appointments/Requests")
end